/*
 * Decompiled with CFR 0.152.
 */
package kaffe.management;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JIT
implements Runnable {
    private LineNumberReader reader;
    private boolean verbose;
    private ClassLoader loader;

    public static native void dumpActiveMethods(PrintStream var0, ClassLoader var1);

    public static void dumpActiveMethods(PrintStream printStream) {
        JIT.dumpActiveMethods(printStream, null);
    }

    public static native void translateMethod(String var0, String var1, String var2, ClassLoader var3);

    public static void translateMethod(String string, String string2, String string3) {
        JIT.translateMethod(string, string2, string3, null);
    }

    public static native void flushCache();

    public static void dumpActiveMethods(String string) throws IOException {
        PrintStream printStream = new PrintStream(new FileOutputStream(string));
        JIT.dumpActiveMethods(printStream);
        printStream.close();
    }

    public static void startPreloading(String string) throws IOException {
        JIT.startPreloading(string, false);
    }

    public static void startPreloading(String string, boolean bl) throws IOException {
        JIT.startPreloading(new FileInputStream(string), null, bl);
    }

    public static void startPreloading(InputStream inputStream, ClassLoader classLoader, boolean bl) throws IOException {
        Thread thread = new Thread(new JIT(inputStream, classLoader, bl));
        thread.setPriority(1);
        thread.start();
    }

    @Override
    public void run() {
        Thread.currentThread().setName("JIT-Translator");
        try {
            String[] stringArray = new String[3];
            while (true) {
                block12: {
                    int n = 0;
                    while (n < stringArray.length) {
                        stringArray[n] = this.reader.readLine();
                        if (stringArray[n] == null) {
                            throw new Exception("reached end of file");
                        }
                        ++n;
                    }
                    if (this.verbose) {
                        System.err.println(new StringBuffer().append("translating ").append(stringArray[0]).append(".").append(stringArray[1]).append(stringArray[2]).toString());
                    }
                    try {
                        JIT.translateMethod(stringArray[0], stringArray[1], stringArray[2], this.loader);
                    }
                    catch (LinkageError linkageError) {
                        if (this.verbose) {
                            System.err.println(new StringBuffer().append("JIT-Translator: ").append(linkageError).toString());
                        }
                    }
                    catch (Exception exception) {
                        if (!this.verbose) break block12;
                        System.err.println(new StringBuffer().append("JIT-Translator: ").append(exception).toString());
                    }
                }
                Thread.yield();
            }
        }
        catch (Exception exception) {
            if (this.verbose) {
                System.err.println(new StringBuffer().append("JIT-Translator: ").append(exception).toString());
            }
            JIT.flushCache();
            if (this.verbose) {
                System.err.println("JIT-Translator done.");
            }
            return;
        }
    }

    private JIT(InputStream inputStream, ClassLoader classLoader, boolean bl) throws IOException {
        this.verbose = bl;
        this.loader = classLoader;
        this.reader = new LineNumberReader(new InputStreamReader(inputStream));
    }

    public static void main(String[] stringArray) throws IOException {
        PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(stringArray[0])));
        JIT.dumpActiveMethods(printStream);
        System.exit(0);
    }

    static {
        System.loadLibrary("management");
    }
}

