/*
 * Decompiled with CFR 0.152.
 */
package kaffe.rmi.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.server.RMIClassLoader;
import kaffe.rmi.server.UnicastConnectionManager;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIObjectInputStream
extends ObjectInputStream {
    UnicastConnectionManager manager;

    public RMIObjectInputStream(InputStream inputStream, UnicastConnectionManager unicastConnectionManager) throws IOException {
        super(inputStream);
        this.manager = unicastConnectionManager;
        this.enableResolveObject(true);
    }

    @Override
    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = (String)this.readObject();
        if (string == null) {
            return super.resolveClass(objectStreamClass);
        }
        try {
            return RMIClassLoader.loadClass(new URL(string), objectStreamClass.getName());
        }
        catch (MalformedURLException malformedURLException) {
            throw new ClassNotFoundException(objectStreamClass.getName());
        }
    }
}

