/*
 * Decompiled with CFR 0.152.
 */
package kaffe.rmi.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.Operation;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.UID;
import java.rmi.server.UnicastRemoteObject;
import kaffe.rmi.server.ProtocolConstants;
import kaffe.rmi.server.UnicastConnection;
import kaffe.rmi.server.UnicastConnectionManager;
import kaffe.rmi.server.UnicastRemoteCall;
import kaffe.util.NotImplemented;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicastRef
implements RemoteRef,
ProtocolConstants {
    public ObjID objid;
    UnicastConnectionManager manager;

    private UnicastRef() {
    }

    public UnicastRef(ObjID objID, String string, int n, RMIClientSocketFactory rMIClientSocketFactory) {
        this(objID);
        this.manager = UnicastConnectionManager.getInstance(string, n, rMIClientSocketFactory);
    }

    public UnicastRef(ObjID objID) {
        this.objid = objID;
    }

    @Override
    public Object invoke(Remote remote, Method method, Object[] objectArray, long l) throws Exception {
        return this.invokeCommon(remote, method, objectArray, -1, l);
    }

    private Object invokeCommon(Remote remote, Method method, Object[] objectArray, int n, long l) throws Exception {
        Object object;
        int n2;
        UnicastConnection unicastConnection;
        try {
            unicastConnection = this.manager.getConnection();
        }
        catch (IOException iOException) {
            throw new RemoteException(new StringBuffer().append("connection failed to host: ").append(this.manager.serverName).toString(), iOException);
        }
        try {
            DataOutputStream dataOutputStream = unicastConnection.getDataOutputStream();
            dataOutputStream.writeByte(80);
            ObjectOutputStream objectOutputStream = unicastConnection.getObjectOutputStream();
            this.objid.write(objectOutputStream);
            objectOutputStream.writeInt(n);
            objectOutputStream.writeLong(l);
            if (objectArray != null) {
                n2 = 0;
                while (n2 < objectArray.length) {
                    if (objectArray[n2] instanceof UnicastRemoteObject) {
                        objectOutputStream.writeObject(UnicastRemoteObject.exportObject((UnicastRemoteObject)objectArray[n2]));
                    } else {
                        objectOutputStream.writeObject(objectArray[n2]);
                    }
                    ++n2;
                }
            }
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new RemoteException("call failed: ", iOException);
        }
        try {
            DataInputStream dataInputStream = unicastConnection.getDataInputStream();
            if (dataInputStream.readUnsignedByte() != 81) {
                throw new RemoteException("Call not acked");
            }
            ObjectInputStream objectInputStream = unicastConnection.getObjectInputStream();
            n2 = objectInputStream.readUnsignedByte();
            UID uID = UID.read(objectInputStream);
            object = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new RemoteException("call return failed: ", iOException);
        }
        this.manager.discardConnection(unicastConnection);
        if (n2 != 1) {
            throw (Exception)object;
        }
        return object;
    }

    @Override
    public RemoteCall newCall(RemoteObject remoteObject, Operation[] operationArray, int n, long l) throws RemoteException {
        return new UnicastRemoteCall(remoteObject, n, l);
    }

    @Override
    public void invoke(RemoteCall remoteCall) throws Exception {
        UnicastRemoteCall unicastRemoteCall = (UnicastRemoteCall)remoteCall;
        Object object = this.invokeCommon((Remote)unicastRemoteCall.getObject(), null, unicastRemoteCall.getArguments(), unicastRemoteCall.getOpnum(), unicastRemoteCall.getHash());
        unicastRemoteCall.setReturnValue(object);
    }

    @Override
    public void done(RemoteCall remoteCall) throws RemoteException {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.manager == null) {
            throw new IOException("no connection");
        }
        this.manager.write(objectOutput);
        this.objid.write(objectOutput);
        objectOutput.writeByte(1);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.manager = UnicastConnectionManager.read(objectInput);
        this.objid = ObjID.read(objectInput);
        if (objectInput.readByte() != 1) {
            throw new IOException("no ack found");
        }
    }

    @Override
    public boolean remoteEquals(RemoteRef remoteRef) {
        throw new NotImplemented();
    }

    @Override
    public int remoteHashCode() {
        throw new NotImplemented();
    }

    @Override
    public String getRefClass(ObjectOutput objectOutput) {
        return "UnicastRef";
    }

    @Override
    public String remoteToString() {
        throw new NotImplemented();
    }

    public void dump(UnicastConnection unicastConnection) {
        try {
            DataInputStream dataInputStream = unicastConnection.getDataInputStream();
            while (true) {
                int n = dataInputStream.readUnsignedByte();
                System.out.print(Integer.toHexString(n));
                if (n >= 32 && n < 128) {
                    System.out.print(new StringBuffer().append(": ").append((char)n).toString());
                }
                System.out.println();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }
}

