/*
 * Decompiled with CFR 0.152.
 */
package kaffe.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.rmi.server.RemoteCall;
import java.util.Vector;
import kaffe.rmi.server.UnicastConnection;
import kaffe.util.NotImplemented;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicastRemoteCall
implements RemoteCall {
    private UnicastConnection conn;
    private Object result;
    private Object object;
    private int opnum;
    private long hash;
    private Vector vec;
    private int ptr;

    UnicastRemoteCall(UnicastConnection unicastConnection) {
        this.conn = unicastConnection;
    }

    UnicastRemoteCall(Object object, int n, long l) {
        this.object = object;
        this.opnum = n;
        this.hash = l;
    }

    @Override
    public ObjectOutput getOutputStream() throws IOException {
        this.vec = new Vector();
        return new DummyObjectOutputStream();
    }

    @Override
    public void releaseOutputStream() throws IOException {
    }

    @Override
    public ObjectInput getInputStream() throws IOException {
        if (this.conn != null) {
            return this.conn.getObjectInputStream();
        }
        this.ptr = 0;
        return new DummyObjectInputStream();
    }

    @Override
    public void releaseInputStream() throws IOException {
    }

    @Override
    public ObjectOutput getResultStream(boolean bl) throws IOException, StreamCorruptedException {
        this.vec = new Vector();
        return new DummyObjectOutputStream();
    }

    @Override
    public void executeCall() throws Exception {
        throw new NotImplemented();
    }

    @Override
    public void done() throws IOException {
    }

    Object returnValue() {
        return this.vec.elementAt(0);
    }

    Object[] getArguments() {
        return this.vec.toArray();
    }

    Object getObject() {
        return this.object;
    }

    int getOpnum() {
        return this.opnum;
    }

    long getHash() {
        return this.hash;
    }

    void setReturnValue(Object object) {
        this.vec.removeAllElements();
        this.vec.addElement(object);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DummyObjectOutputStream
    implements ObjectOutput {
        @Override
        public void writeBoolean(boolean bl) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Boolean(bl));
        }

        @Override
        public void writeByte(int n) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Byte((byte)n));
        }

        @Override
        public void writeChar(int n) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Character((char)n));
        }

        @Override
        public void writeDouble(double d) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Double(d));
        }

        @Override
        public void writeFloat(float f) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Float(f));
        }

        @Override
        public void writeInt(int n) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Integer(n));
        }

        @Override
        public void writeLong(long l) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Long(l));
        }

        @Override
        public void writeShort(int n) throws IOException {
            UnicastRemoteCall.this.vec.addElement(new Short((short)n));
        }

        @Override
        public void writeObject(Object object) throws IOException {
            UnicastRemoteCall.this.vec.addElement(object);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            throw new IOException("not required");
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            throw new IOException("not required");
        }

        @Override
        public void write(int n) throws IOException {
            throw new IOException("not required");
        }

        @Override
        public void writeBytes(String string) throws IOException {
            throw new IOException("not required");
        }

        @Override
        public void writeChars(String string) throws IOException {
            throw new IOException("not required");
        }

        @Override
        public void writeUTF(String string) throws IOException {
            throw new IOException("not required");
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        private DummyObjectOutputStream() {
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DummyObjectInputStream
    implements ObjectInput {
        @Override
        public boolean readBoolean() throws IOException {
            Object object = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return (Boolean)object;
        }

        @Override
        public byte readByte() throws IOException {
            Object object = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return (Byte)object;
        }

        @Override
        public char readChar() throws IOException {
            Object object = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return ((Character)object).charValue();
        }

        @Override
        public double readDouble() throws IOException {
            Object object = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return (Double)object;
        }

        @Override
        public float readFloat() throws IOException {
            Object object = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return ((Float)object).floatValue();
        }

        @Override
        public int readInt() throws IOException {
            Object object = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return (Integer)object;
        }

        @Override
        public long readLong() throws IOException {
            Object object = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return (Long)object;
        }

        @Override
        public short readShort() throws IOException {
            Object object = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return (Short)object;
        }

        @Override
        public Object readObject() throws IOException {
            return UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            throw new IOException("not required");
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            throw new IOException("not required");
        }

        @Override
        public int read() throws IOException {
            throw new IOException("not required");
        }

        @Override
        public long skip(long l) throws IOException {
            throw new IOException("not required");
        }

        @Override
        public int available() throws IOException {
            throw new IOException("not required");
        }

        @Override
        public void readFully(byte[] byArray) throws IOException {
            throw new IOException("not required");
        }

        @Override
        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            throw new IOException("not required");
        }

        @Override
        public String readLine() throws IOException {
            throw new IOException("not required");
        }

        @Override
        public String readUTF() throws IOException {
            throw new IOException("not required");
        }

        @Override
        public int readUnsignedByte() throws IOException {
            throw new IOException("not required");
        }

        @Override
        public int readUnsignedShort() throws IOException {
            throw new IOException("not required");
        }

        @Override
        public int skipBytes(int n) throws IOException {
            throw new IOException("not required");
        }

        @Override
        public void close() throws IOException {
        }

        private DummyObjectInputStream() {
        }
    }
}

