/*
 * Decompiled with CFR 0.152.
 */
package kaffe.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerIntegerHashtable
implements Serializable {
    private static final long serialVersionUID = 329217906565329940L;
    private int[] keys;
    private int[] elements;
    private int iloadFactor;
    private int numberOfKeys;
    private int rehashLimit;
    private static final int DEFAULTCAPACITY = 101;
    private static final int DEFAULTLOADFACTOR = 75;
    private static final int removed = -2;
    private static final int free = -1;

    public IntegerIntegerHashtable() {
        this(101, 75);
    }

    public IntegerIntegerHashtable(int n) {
        this(n, 75);
    }

    public IntegerIntegerHashtable(int n, float f) {
        this(n, (int)((double)f * 5.333806864E-315));
    }

    public IntegerIntegerHashtable(int n, int n2) {
        this.init(n, n2);
    }

    private void init(int n, int n2) {
        if (n <= 0) {
            throw new Error("Initial capacity is <= 0");
        }
        if (n2 <= 0) {
            throw new Error("Load Factor is <= 0");
        }
        this.iloadFactor = n2;
        this.keys = new int[n];
        int n3 = 0;
        while (n3 < n) {
            this.keys[n3] = -1;
            ++n3;
        }
        this.elements = new int[n];
        this.numberOfKeys = 0;
        this.rehashLimit = n2 * n / 100;
    }

    public int size() {
        return this.numberOfKeys;
    }

    public boolean isEmpty() {
        return this.numberOfKeys == 0;
    }

    public synchronized boolean contains(int n) {
        int n2 = this.elements.length - 1;
        while (n2 >= 0) {
            if (n == this.elements[n2]) {
                return true;
            }
            --n2;
        }
        return false;
    }

    public synchronized boolean containsKey(int n) {
        return this.get(n) != -1;
    }

    private int calculateBucket(int n) {
        return n % this.keys.length;
    }

    public synchronized int get(int n) {
        int n2;
        int n3 = this.calculateBucket(n);
        int n4 = this.keys.length;
        int n5 = n3;
        while (n5 < n4) {
            n2 = this.keys[n5];
            if (n == n2) {
                return this.elements[n5];
            }
            if (n2 == -1) {
                return -1;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n3) {
            n2 = this.keys[n5];
            if (n == n2) {
                return this.elements[n5];
            }
            if (n2 == -1) {
                return -1;
            }
            ++n5;
        }
        return -1;
    }

    protected synchronized void rehash() {
        int n = this.keys.length * 2;
        int[] nArray = this.keys;
        int[] nArray2 = this.elements;
        this.keys = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.keys[n2] = -1;
            ++n2;
        }
        this.elements = new int[n];
        this.rehashLimit = this.iloadFactor * n / 100;
        this.numberOfKeys = 0;
        n2 = nArray.length - 1;
        while (n2 >= 0) {
            if (nArray[n2] != -1 && nArray[n2] != -2) {
                this.put(nArray[n2], nArray2[n2]);
            }
            --n2;
        }
    }

    public synchronized int put(int n, int n2) {
        int n3;
        if (this.numberOfKeys >= this.rehashLimit) {
            this.rehash();
        }
        int n4 = this.calculateBucket(n);
        int n5 = this.keys.length;
        int n6 = -1;
        int n7 = n4;
        while (n7 < n5) {
            n3 = this.keys[n7];
            if (n3 == -2) {
                if (n6 == -1) {
                    n6 = n7;
                }
            } else {
                if (n3 == -1) {
                    if (n6 == -1) {
                        n6 = n7;
                    }
                    this.keys[n6] = n;
                    this.elements[n6] = n2;
                    ++this.numberOfKeys;
                    return -1;
                }
                if (n == n3) {
                    int n8 = this.elements[n7];
                    this.elements[n7] = n2;
                    return n8;
                }
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n4) {
            n3 = this.keys[n7];
            if (n == n3) {
                int n9 = this.elements[n7];
                this.elements[n7] = n2;
                return n9;
            }
            if (n3 == -2) {
                if (n6 == -1) {
                    n6 = n7;
                }
            } else if (n3 == -1) {
                if (n6 == -1) {
                    n6 = n7;
                }
                this.keys[n6] = n;
                this.elements[n6] = n2;
                ++this.numberOfKeys;
                return -1;
            }
            ++n7;
        }
        if (n6 != -1) {
            this.keys[n6] = n;
            this.elements[n6] = n2;
            ++this.numberOfKeys;
            return -1;
        }
        throw new Error("Inconsistent Hashtable");
    }

    public synchronized int remove(int n) {
        int n2;
        int n3 = this.calculateBucket(n);
        int n4 = this.keys.length;
        int n5 = n3;
        while (n5 < n4) {
            n2 = this.keys[n5];
            if (n == n2) {
                int n6 = this.elements[n5];
                this.elements[n5] = -1;
                this.keys[n5] = -2;
                this.numberOfKeys += -1;
                return n6;
            }
            if (n2 == -1) {
                return -1;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n3) {
            n2 = this.keys[n5];
            if (n == n2) {
                int n7 = this.elements[n5];
                this.elements[n5] = -1;
                this.keys[n5] = -2;
                this.numberOfKeys += -1;
                return n7;
            }
            if (n2 == -1) {
                return -1;
            }
            ++n5;
        }
        return -1;
    }

    public synchronized void clear() {
        int n = this.keys.length - 1;
        while (n >= 0) {
            this.keys[n] = -1;
            this.elements[n] = -1;
            --n;
        }
        this.numberOfKeys = 0;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n] != -1 && this.keys[n] != -2) {
                stringBuffer.append(this.keys[n]);
                stringBuffer.append("=");
                stringBuffer.append(this.elements[n]);
                break;
            }
            ++n;
        }
        while (n < this.keys.length) {
            if (this.keys[n] != -1 && this.keys[n] != -2) {
                stringBuffer.append(", ");
                stringBuffer.append(this.keys[n]);
                stringBuffer.append("=");
                stringBuffer.append(this.elements[n]);
            }
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.numberOfKeys);
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n] != -1 && this.keys[n] != -2) {
                objectOutputStream.writeInt(this.keys[n]);
                objectOutputStream.writeInt(this.elements[n]);
            }
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init(101, 75);
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            int n3 = objectInputStream.readInt();
            int n4 = objectInputStream.readInt();
            this.put(n3, n4);
            ++n2;
        }
    }
}

