/*
 * Decompiled with CFR 0.152.
 */
package kaffe.util;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongHashtable {
    private long[] keys;
    private Object[] elements;
    private int iloadFactor;
    private int numberOfKeys;
    private int rehashLimit;
    private static final int DEFAULTCAPACITY = 101;
    private static final int DEFAULTLOADFACTOR = 75;
    private static final long removed = -2L;
    private static final long free = -1L;

    public LongHashtable() {
        this(101, 75);
    }

    public LongHashtable(int n) {
        this(n, 75);
    }

    public LongHashtable(int n, float f) {
        this(n, (int)((double)f * 5.333806864E-315));
    }

    public LongHashtable(int n, int n2) {
        if (n <= 0) {
            throw new Error("Initial capacity is <= 0");
        }
        if (n2 <= 0) {
            throw new Error("Load Factor is <= 0");
        }
        this.iloadFactor = n2;
        this.keys = new long[n];
        int n3 = 0;
        while (n3 < n) {
            this.keys[n3] = -1L;
            ++n3;
        }
        this.elements = new Object[n];
        this.numberOfKeys = 0;
        this.rehashLimit = n2 * n / 100;
    }

    public int size() {
        return this.numberOfKeys;
    }

    public boolean isEmpty() {
        return this.numberOfKeys == 0;
    }

    public synchronized boolean contains(Object object) {
        int n = this.elements.length - 1;
        while (n >= 0) {
            if (object.equals(this.elements[n])) {
                return true;
            }
            --n;
        }
        return false;
    }

    public synchronized boolean containsKey(long l) {
        return this.get(l) != null;
    }

    private int calculateBucket(long l) {
        return (int)l % this.keys.length & Integer.MAX_VALUE;
    }

    public synchronized Object get(long l) {
        long l2;
        int n = this.calculateBucket(l);
        int n2 = this.keys.length;
        int n3 = n;
        while (n3 < n2) {
            l2 = this.keys[n3];
            if (l == l2) {
                return this.elements[n3];
            }
            if (l2 == -1L) {
                return null;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            l2 = this.keys[n3];
            if (l == l2) {
                return this.elements[n3];
            }
            if (l2 == -1L) {
                return null;
            }
            ++n3;
        }
        return null;
    }

    protected synchronized void rehash() {
        int n = this.keys.length * 2;
        long[] lArray = this.keys;
        Object[] objectArray = this.elements;
        this.keys = new long[n];
        int n2 = 0;
        while (n2 < n) {
            this.keys[n2] = -1L;
            ++n2;
        }
        this.elements = new Object[n];
        this.rehashLimit = this.iloadFactor * n / 100;
        this.numberOfKeys = 0;
        n2 = lArray.length - 1;
        while (n2 >= 0) {
            if (lArray[n2] != -1L && lArray[n2] != -2L) {
                this.put(lArray[n2], objectArray[n2]);
            }
            --n2;
        }
    }

    public synchronized Object put(long l, Object object) {
        long l2;
        if (this.numberOfKeys >= this.rehashLimit) {
            this.rehash();
        }
        int n = this.calculateBucket(l);
        int n2 = this.keys.length;
        int n3 = -1;
        int n4 = n;
        while (n4 < n2) {
            l2 = this.keys[n4];
            if (l2 == -2L) {
                if (n3 == -1) {
                    n3 = n4;
                }
            } else {
                if (l2 == -1L) {
                    if (n3 == -1) {
                        n3 = n4;
                    }
                    this.keys[n3] = l;
                    this.elements[n3] = object;
                    ++this.numberOfKeys;
                    return null;
                }
                if (l == l2) {
                    Object object2 = this.elements[n4];
                    this.elements[n4] = object;
                    return object2;
                }
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n) {
            l2 = this.keys[n4];
            if (l == l2) {
                Object object3 = this.elements[n4];
                this.elements[n4] = object;
                return object3;
            }
            if (l2 == -2L) {
                if (n3 == -1) {
                    n3 = n4;
                }
            } else if (l2 == -1L) {
                if (n3 == -1) {
                    n3 = n4;
                }
                this.keys[n3] = l;
                this.elements[n3] = object;
                ++this.numberOfKeys;
                return null;
            }
            ++n4;
        }
        if (n3 != -1) {
            this.keys[n3] = l;
            this.elements[n3] = object;
            ++this.numberOfKeys;
            return null;
        }
        throw new Error("Inconsistent Hashtable");
    }

    public synchronized Object remove(long l) {
        long l2;
        int n = this.calculateBucket(l);
        int n2 = this.keys.length;
        int n3 = n;
        while (n3 < n2) {
            l2 = this.keys[n3];
            if (l == l2) {
                Object object = this.elements[n3];
                this.elements[n3] = null;
                this.keys[n3] = -2L;
                this.numberOfKeys += -1;
                return object;
            }
            if (l2 == -1L) {
                return null;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            l2 = this.keys[n3];
            if (l == l2) {
                Object object = this.elements[n3];
                this.elements[n3] = null;
                this.keys[n3] = -2L;
                this.numberOfKeys += -1;
                return object;
            }
            if (l2 == -1L) {
                return null;
            }
            ++n3;
        }
        return null;
    }

    public synchronized void clear() {
        int n = this.keys.length - 1;
        while (n >= 0) {
            this.keys[n] = -1L;
            this.elements[n] = null;
            --n;
        }
        this.numberOfKeys = 0;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n] != -1L && this.keys[n] != -2L) {
                stringBuffer.append(this.keys[n]);
                stringBuffer.append("=");
                stringBuffer.append(this.elements[n]);
                break;
            }
            ++n;
        }
        while (n < this.keys.length) {
            if (this.keys[n] != -1L && this.keys[n] != -2L) {
                stringBuffer.append(", ");
                stringBuffer.append(this.keys[n]);
                stringBuffer.append("=");
                stringBuffer.append(this.elements[n]);
            }
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

