/*
 * Decompiled with CFR 0.152.
 */
package kaffe.util.log;

import java.io.OutputStream;
import java.util.Vector;
import kaffe.util.DoubleLinkedObject;
import kaffe.util.log.LogClient;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogStream
extends OutputStream {
    private DoubleLinkedObject first;
    private DoubleLinkedObject last;
    private StringBuffer current;
    private int nLines;
    private int limit;
    private Object client;

    public LogStream(int n) {
        this.Block$();
        this.limit = n;
    }

    public LogStream(int n, LogClient logClient) {
        this.Block$();
        this.limit = n;
        this.client = logClient;
    }

    public void addClient(LogClient logClient) {
        if (this.client == null) {
            this.client = logClient;
            return;
        }
        if (this.client instanceof Vector) {
            ((Vector)this.client).addElement(logClient);
            return;
        }
        Vector vector = new Vector(2);
        vector.addElement(this.client);
        vector.addElement(logClient);
        this.client = vector;
    }

    public DoubleLinkedObject getFirstLine() {
        return this.first;
    }

    public DoubleLinkedObject getLastLine() {
        return this.last;
    }

    void notifyClient() {
        if (this.client != null) {
            if (this.client instanceof LogClient) {
                ((LogClient)this.client).newLogLine(this);
                return;
            }
            if (this.client instanceof Vector) {
                Vector vector = (Vector)this.client;
                int n = vector.size();
                int n2 = 0;
                while (n2 < n) {
                    ((LogClient)vector.elementAt(n2)).newLogLine(this);
                    ++n2;
                }
            }
        }
    }

    public void removeClient(LogClient logClient) {
        if (this.client != null) {
            if (this.client instanceof Vector) {
                ((Vector)this.client).removeElement(logClient);
                return;
            }
            if (this.client == logClient) {
                this.client = null;
            }
        }
    }

    @Override
    public void write(int n) {
        if (n == 10) {
            if (this.nLines > this.limit) {
                this.first = this.first.next;
            }
            DoubleLinkedObject doubleLinkedObject = new DoubleLinkedObject(new String(this.current), this.last, null);
            if (this.first == null) {
                this.first = this.last = doubleLinkedObject;
            } else {
                this.last = doubleLinkedObject;
            }
            this.current.setLength(0);
            ++this.nLines;
            this.notifyClient();
            return;
        }
        if (n == 9 || n >= 32) {
            this.current.append((char)n);
        }
    }

    private /* synthetic */ void Block$() {
        this.current = new StringBuffer(80);
    }
}

