/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.core;

import java.util.Iterator;
import java.util.Set;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;
import org.tritonus.core.TInit;
import org.tritonus.share.ArraySet;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAudioConfig {
    private static Set sm_audioFileWriters = null;
    private static Set sm_audioFileReaders = null;
    private static Set sm_formatConversionProviders = null;
    private static Set sm_mixerProviders = null;
    private static Mixer.Info sm_defaultMixerInfo;

    private TAudioConfig() {
    }

    private static void registerAudioFileReaders() {
        4 var0 = null;
        var0 = new 4();
        TInit.registerClasses(Class.forName("javax.sound.sampled.spi.AudioFileReader"), var0);
    }

    private static void registerAudioFileWriters() {
        3 var0 = null;
        var0 = new 3();
        TInit.registerClasses(Class.forName("javax.sound.sampled.spi.AudioFileWriter"), var0);
    }

    private static void registerFormatConversionProviders() {
        2 var0 = null;
        var0 = new 2();
        TInit.registerClasses(Class.forName("javax.sound.sampled.spi.FormatConversionProvider"), var0);
    }

    private static void registerMixerProviders() {
        1 var0 = null;
        var0 = new 1();
        TInit.registerClasses(Class.forName("javax.sound.sampled.spi.MixerProvider"), var0);
    }

    public static synchronized void addAudioFileReader(AudioFileReader audioFileReader) {
        TAudioConfig.getAudioFileReadersImpl().add(audioFileReader);
    }

    public static synchronized void removeAudioFileReader(AudioFileReader audioFileReader) {
        TAudioConfig.getAudioFileReadersImpl().remove(audioFileReader);
    }

    public static synchronized Iterator getAudioFileReaders() {
        return TAudioConfig.getAudioFileReadersImpl().iterator();
    }

    private static synchronized Set getAudioFileReadersImpl() {
        if (sm_audioFileReaders == null) {
            sm_audioFileReaders = new ArraySet();
            TAudioConfig.registerAudioFileReaders();
        }
        return sm_audioFileReaders;
    }

    public static synchronized void addAudioFileWriter(AudioFileWriter audioFileWriter) {
        TAudioConfig.getAudioFileWritersImpl().add(audioFileWriter);
    }

    public static synchronized void removeAudioFileWriter(AudioFileWriter audioFileWriter) {
        TAudioConfig.getAudioFileWritersImpl().remove(audioFileWriter);
    }

    public static synchronized Iterator getAudioFileWriters() {
        return TAudioConfig.getAudioFileWritersImpl().iterator();
    }

    private static synchronized Set getAudioFileWritersImpl() {
        if (sm_audioFileWriters == null) {
            sm_audioFileWriters = new ArraySet();
            TAudioConfig.registerAudioFileWriters();
        }
        return sm_audioFileWriters;
    }

    public static synchronized void addFormatConversionProvider(FormatConversionProvider formatConversionProvider) {
        TAudioConfig.getFormatConversionProvidersImpl().add(formatConversionProvider);
    }

    public static synchronized void removeFormatConversionProvider(FormatConversionProvider formatConversionProvider) {
        TAudioConfig.getFormatConversionProvidersImpl().remove(formatConversionProvider);
    }

    public static synchronized Iterator getFormatConversionProviders() {
        return TAudioConfig.getFormatConversionProvidersImpl().iterator();
    }

    private static synchronized Set getFormatConversionProvidersImpl() {
        if (sm_formatConversionProviders == null) {
            sm_formatConversionProviders = new ArraySet();
            TAudioConfig.registerFormatConversionProviders();
        }
        return sm_formatConversionProviders;
    }

    public static synchronized void addMixerProvider(MixerProvider mixerProvider) {
        TAudioConfig.getMixerProvidersImpl().add(mixerProvider);
    }

    public static synchronized void removeMixerProvider(MixerProvider mixerProvider) {
        TAudioConfig.getMixerProvidersImpl().remove(mixerProvider);
    }

    public static synchronized Iterator getMixerProviders() {
        return TAudioConfig.getMixerProvidersImpl().iterator();
    }

    private static synchronized Set getMixerProvidersImpl() {
        if (sm_mixerProviders == null) {
            sm_mixerProviders = new ArraySet();
            TAudioConfig.registerMixerProviders();
        }
        return sm_mixerProviders;
    }

    public static Mixer.Info getDefaultMixerInfo() {
        return sm_defaultMixerInfo;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1
    implements TInit.ProviderRegistrationAction {
        @Override
        public void register(Object object) throws Exception {
            MixerProvider mixerProvider = (MixerProvider)object;
            TAudioConfig.addMixerProvider(mixerProvider);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 2
    implements TInit.ProviderRegistrationAction {
        @Override
        public void register(Object object) throws Exception {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)object;
            TAudioConfig.addFormatConversionProvider(formatConversionProvider);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 3
    implements TInit.ProviderRegistrationAction {
        @Override
        public void register(Object object) throws Exception {
            AudioFileWriter audioFileWriter = (AudioFileWriter)object;
            TAudioConfig.addAudioFileWriter(audioFileWriter);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 4
    implements TInit.ProviderRegistrationAction {
        @Override
        public void register(Object object) throws Exception {
            AudioFileReader audioFileReader = (AudioFileReader)object;
            TAudioConfig.addAudioFileReader(audioFileReader);
        }
    }
}

