/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.MidiUtils;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlsaMidiChannel
implements MidiChannel {
    private Receiver m_receiver;
    private int m_nChannel;

    public AlsaMidiChannel(Receiver receiver, int n) {
        this.m_receiver = receiver;
        this.m_nChannel = n;
    }

    protected int getChannel() {
        return this.m_nChannel;
    }

    protected void sendMessage(MidiMessage midiMessage) {
        this.m_receiver.send(midiMessage, -1L);
    }

    @Override
    public void noteOn(int n, int n2) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(144, this.getChannel(), n, n2);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    @Override
    public void noteOff(int n, int n2) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(128, this.getChannel(), n, n2);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    @Override
    public void noteOff(int n) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(128, this.getChannel(), n, 0);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    @Override
    public void setPolyPressure(int n, int n2) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(160, n2, 0);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    @Override
    public int getPolyPressure(int n) {
        return -1;
    }

    @Override
    public void setChannelPressure(int n) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(208, this.getChannel(), n, 0);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    @Override
    public int getChannelPressure() {
        return -1;
    }

    @Override
    public void controlChange(int n, int n2) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(176, this.getChannel(), n, n2);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    @Override
    public int getController(int n) {
        return -1;
    }

    @Override
    public void programChange(int n) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(192, this.getChannel(), n, 0);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    @Override
    public void programChange(int n, int n2) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(192, this.getChannel(), n2, 0);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    @Override
    public int getProgram() {
        return -1;
    }

    @Override
    public void setPitchBend(int n) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(224, MidiUtils.get14bitLSB(n), MidiUtils.get14bitMSB(n));
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    @Override
    public int getPitchBend() {
        return -1;
    }

    @Override
    public void resetAllControllers() {
    }

    @Override
    public void allNotesOff() {
    }

    @Override
    public void allSoundOff() {
    }

    @Override
    public boolean localControl(boolean bl) {
        return false;
    }

    @Override
    public void setMono(boolean bl) {
    }

    @Override
    public boolean getMono() {
        return false;
    }

    @Override
    public void setOmni(boolean bl) {
    }

    @Override
    public boolean getOmni() {
        return false;
    }

    @Override
    public void setMute(boolean bl) {
    }

    @Override
    public boolean getMute() {
        return false;
    }

    @Override
    public void setSolo(boolean bl) {
    }

    @Override
    public boolean getSolo() {
        return false;
    }
}

