/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;
import org.tritonus.lowlevel.alsa.AlsaSeq;
import org.tritonus.lowlevel.alsa.AlsaSeqClientInfo;
import org.tritonus.lowlevel.alsa.AlsaSeqPortInfo;
import org.tritonus.midi.device.alsa.AlsaMidiDevice;
import org.tritonus.midi.device.alsa.AlsaSynthesizer;
import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlsaMidiDeviceProvider
extends MidiDeviceProvider {
    private static final MidiDevice.Info[] EMPTY_INFO_ARRAY = new MidiDevice.Info[0];
    private static final int READ_CAPABILITY = 33;
    private static final int WRITE_CAPABILITY = 66;
    private static List m_devices;
    private static AlsaSeq m_alsaSeq;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlsaMidiDeviceProvider() {
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.<init>(): begin");
        }
        Class clazz = Class.forName("org.tritonus.midi.device.alsa.AlsaMidiDeviceProvider");
        synchronized (clazz) {
            if (m_devices == null) {
                m_devices = new ArrayList();
                if (TDebug.TraceMidiDeviceProvider) {
                    TDebug.out("AlsaMidiDeviceProvider.<init>(): creating AlsaSeq...");
                }
                m_alsaSeq = new AlsaSeq("Tritonus ALSA device manager");
                if (TDebug.TraceMidiDeviceProvider) {
                    TDebug.out("AlsaMidiDeviceProvider.<init>(): ...done");
                }
                this.scanPorts();
            }
        }
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.<init>(): end");
        }
    }

    @Override
    public MidiDevice.Info[] getDeviceInfo() {
        MidiDevice.Info[] infoArray;
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.getDeviceInfo(): begin");
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = m_devices.iterator();
        while (iterator.hasNext()) {
            infoArray = (MidiDevice.Info[])iterator.next();
            MidiDevice.Info info = infoArray.getDeviceInfo();
            arrayList.add(info);
        }
        infoArray = (MidiDevice.Info[])arrayList.toArray(EMPTY_INFO_ARRAY);
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.getDeviceInfo(): end");
        }
        return infoArray;
    }

    @Override
    public MidiDevice getDevice(MidiDevice.Info info) {
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.getDevice(): begin");
        }
        MidiDevice midiDevice = null;
        Iterator iterator = m_devices.iterator();
        while (iterator.hasNext()) {
            MidiDevice midiDevice2 = (MidiDevice)iterator.next();
            MidiDevice.Info info2 = midiDevice2.getDeviceInfo();
            if (info == null || !info.equals(info2)) continue;
            midiDevice = midiDevice2;
            break;
        }
        if (midiDevice == null) {
            throw new IllegalArgumentException(new StringBuffer().append("no device for ").append(info).toString());
        }
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.getDevice(): end");
        }
        return midiDevice;
    }

    private void scanPorts() {
        if (TDebug.TraceMidiDeviceProvider || TDebug.TracePortScan) {
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): begin");
        }
        Iterator iterator = m_alsaSeq.getClientInfos();
        while (iterator.hasNext()) {
            AlsaSeqClientInfo alsaSeqClientInfo = (AlsaSeqClientInfo)iterator.next();
            int n = alsaSeqClientInfo.getClient();
            if (TDebug.TracePortScan) {
                TDebug.out(new StringBuffer().append("AlsaMidiDeviceProvider.scanPorts(): client: ").append(n).toString());
            }
            Iterator iterator2 = m_alsaSeq.getPortInfos(n);
            while (iterator2.hasNext()) {
                AlsaSeqPortInfo alsaSeqPortInfo = (AlsaSeqPortInfo)iterator2.next();
                this.handlePort(alsaSeqClientInfo, alsaSeqPortInfo);
            }
        }
        if (TDebug.TraceMidiDeviceProvider || TDebug.TracePortScan) {
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): end");
        }
    }

    private void handlePort(AlsaSeqClientInfo alsaSeqClientInfo, AlsaSeqPortInfo alsaSeqPortInfo) {
        int n = alsaSeqClientInfo.getClient();
        int n2 = alsaSeqPortInfo.getPort();
        int n3 = alsaSeqPortInfo.getType();
        int n4 = alsaSeqPortInfo.getCapability();
        int n5 = alsaSeqPortInfo.getSynthVoices();
        if (TDebug.TracePortScan) {
            TDebug.out(new StringBuffer().append("AlsaMidiDeviceProvider.scanPorts(): port: ").append(n2).toString());
            TDebug.out(new StringBuffer().append("AlsaMidiDeviceProvider.scanPorts(): type: ").append(n3).toString());
            TDebug.out(new StringBuffer().append("AlsaMidiDeviceProvider.scanPorts(): cap: ").append(n4).toString());
            TDebug.out(new StringBuffer().append("AlsaMidiDeviceProvider.scanPorts(): midi channels: ").append(alsaSeqPortInfo.getMidiChannels()).toString());
            TDebug.out(new StringBuffer().append("AlsaMidiDeviceProvider.scanPorts(): midi voices: ").append(alsaSeqPortInfo.getMidiVoices()).toString());
            TDebug.out(new StringBuffer().append("AlsaMidiDeviceProvider.scanPorts(): synth voices: ").append(alsaSeqPortInfo.getSynthVoices()).toString());
        }
        if ((n3 & 2) != 0) {
            AlsaMidiDevice alsaMidiDevice = null;
            if ((n3 & 0x1C00) != 0) {
                boolean bl;
                boolean bl2 = bl = (n4 & 0x42) == 66;
                if (bl) {
                    alsaMidiDevice = new AlsaSynthesizer(n, n2, n5);
                } else if (TDebug.TraceMidiDeviceProvider) {
                    TDebug.out("AlsaMidiDeviceProvider.getDevice(): port does not allows write subscription, not used");
                }
            } else {
                boolean bl;
                boolean bl3 = (n4 & 0x21) == 33;
                boolean bl4 = bl = (n4 & 0x42) == 66;
                if (bl3 || bl) {
                    alsaMidiDevice = new AlsaMidiDevice(n, n2, bl3, bl);
                } else if (TDebug.TraceMidiDeviceProvider) {
                    TDebug.out("AlsaMidiDeviceProvider.getDevice(): port allows neither read nor write subscription, not used");
                }
            }
            if (alsaMidiDevice != null) {
                m_devices.add(alsaMidiDevice);
            }
        }
    }
}

