/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;
import org.tritonus.midi.device.alsa.AlsaSequencer;
import org.tritonus.share.GlobalInfo;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.TMidiDevice;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlsaSequencerProvider
extends MidiDeviceProvider {
    private static MidiDevice.Info sm_info;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlsaSequencerProvider() {
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaSequencerProvider.<init>(): begin");
        }
        Class clazz = Class.forName("org.tritonus.midi.device.alsa.AlsaSequencerProvider");
        synchronized (clazz) {
            if (sm_info == null) {
                sm_info = new TMidiDevice.Info("Tritonus ALSA Sequencer", GlobalInfo.getVendor(), "this sequencer uses the ALSA sequencer", GlobalInfo.getVersion());
            }
        }
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaSequencerProvider.<init>(): end");
        }
    }

    @Override
    public MidiDevice.Info[] getDeviceInfo() {
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaSequencerProvider.getDeviceInfo(): begin");
        }
        MidiDevice.Info[] infoArray = new MidiDevice.Info[]{sm_info};
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaSequencerProvider.getDeviceInfo(): end");
        }
        return infoArray;
    }

    @Override
    public MidiDevice getDevice(MidiDevice.Info info) {
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaSequencerProvider.getDevice(): begin");
        }
        AlsaSequencer alsaSequencer = null;
        if (info != null && info.equals(sm_info)) {
            alsaSequencer = new AlsaSequencer(sm_info);
        }
        if (alsaSequencer == null) {
            throw new IllegalArgumentException(new StringBuffer().append("no device for ").append(info).toString());
        }
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaSequencerProvider.getDevice(): end");
        }
        return alsaSequencer;
    }
}

