/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.alsa;

import org.tritonus.lowlevel.alsa.Alsa;
import org.tritonus.lowlevel.alsa.AlsaCtl;
import org.tritonus.lowlevel.alsa.AlsaCtlCardInfo;
import org.tritonus.sampled.mixer.alsa.AlsaDataLineMixer;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.mixer.TMixerProvider;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlsaDataLineMixerProvider
extends TMixerProvider {
    private static boolean sm_bInitialized = false;

    public AlsaDataLineMixerProvider() {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("AlsaDataLineMixerProvider.<init>(): begin");
        }
        if (!sm_bInitialized && !this.isDisabled()) {
            if (!Alsa.isLibraryAvailable()) {
                this.disable();
            } else {
                this.staticInit();
                sm_bInitialized = true;
            }
        } else if (TDebug.TraceMixerProvider) {
            TDebug.out("AlsaDataLineMixerProvider.<init>(): already initialized or disabled");
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("AlsaDataLineMixerProvider.<init>(): end");
        }
    }

    @Override
    protected void staticInit() {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("AlsaDataLineMixerProvider.staticInit(): begin");
        }
        int[] nArray = AlsaCtl.getCards();
        if (TDebug.TraceMixerProvider) {
            TDebug.out(new StringBuffer().append("AlsaDataLineMixerProvider.staticInit(): num cards: ").append(nArray.length).toString());
        }
        int n = 0;
        while (n < nArray.length) {
            block14: {
                if (TDebug.TraceMixerProvider) {
                    TDebug.out(new StringBuffer().append("AlsaDataLineMixerProvider.staticInit():card #").append(n).append(": ").append(nArray[n]).toString());
                }
                if (TDebug.TraceMixerProvider) {
                    TDebug.out("AlsaDataLineMixerProvider.staticInit(): creating Ctl object...");
                }
                String string = new StringBuffer().append("hw:").append(nArray[n]).toString();
                AlsaCtl alsaCtl = null;
                try {
                    alsaCtl = new AlsaCtl(string, 0);
                }
                catch (Exception exception) {
                    if (TDebug.TraceMixerProvider || TDebug.TraceAllExceptions) {
                        TDebug.out(exception);
                    }
                    break block14;
                }
                if (TDebug.TraceMixerProvider) {
                    TDebug.out("AlsaDataLineMixerProvider.staticInit(): calling getCardInfo()...");
                }
                AlsaCtlCardInfo alsaCtlCardInfo = new AlsaCtlCardInfo();
                alsaCtl.getCardInfo(alsaCtlCardInfo);
                if (TDebug.TraceMixerProvider) {
                    TDebug.out("AlsaDataLineMixerProvider.staticInit(): ALSA sound card:");
                    TDebug.out(new StringBuffer().append("AlsaDataLineMixerProvider.staticInit(): card: ").append(alsaCtlCardInfo.getCard()).toString());
                    TDebug.out(new StringBuffer().append("AlsaDataLineMixerProvider.staticInit(): id: ").append(alsaCtlCardInfo.getId()).toString());
                }
                int[] nArray2 = alsaCtl.getPcmDevices();
                if (TDebug.TraceMixerProvider) {
                    TDebug.out(new StringBuffer().append("AlsaDataLineMixerProvider.staticInit(): num devices: ").append(nArray2.length).toString());
                }
                int n2 = 0;
                while (n2 < nArray2.length) {
                    if (TDebug.TraceMixerProvider) {
                        TDebug.out(new StringBuffer().append("AlsaDataLineMixerProvider.staticInit(): device #").append(n2).append(": ").append(nArray2[n2]).toString());
                    }
                    ++n2;
                }
                AlsaDataLineMixer alsaDataLineMixer = new AlsaDataLineMixer(nArray[n]);
                super.addMixer(alsaDataLineMixer);
            }
            ++n;
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("AlsaDataLineMixerProvider.staticInit(): end");
        }
    }
}

