/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share;

import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCircularBuffer {
    private boolean m_bBlockingRead;
    private boolean m_bBlockingWrite;
    private byte[] m_abData;
    private int m_nSize;
    private int m_nReadPos;
    private int m_nWritePos;
    private Trigger m_trigger;
    private boolean m_bOpen;

    public TCircularBuffer(int n, boolean bl, boolean bl2, Trigger trigger) {
        this.m_bBlockingRead = bl;
        this.m_bBlockingWrite = bl2;
        this.m_nSize = n;
        this.m_abData = new byte[this.m_nSize];
        this.m_nReadPos = 0;
        this.m_nWritePos = 0;
        this.m_trigger = trigger;
        this.m_bOpen = true;
    }

    public void close() {
        this.m_bOpen = false;
    }

    public int availableRead() {
        return this.m_nWritePos - this.m_nReadPos;
    }

    public int availableWrite() {
        return this.m_nSize - this.availableRead();
    }

    private int getReadPos() {
        return this.m_nReadPos % this.m_nSize;
    }

    private int getWritePos() {
        return this.m_nWritePos % this.m_nSize;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int read(byte[] var1_1, int var2_2, int var3_3) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out(">TCircularBuffer.read(): called.");
            TDebug.out(new StringBuffer().append("m_nReadPos  = ").append(this.m_nReadPos).append(" ^= ").append(this.getReadPos()).toString());
            TDebug.out(new StringBuffer().append("m_nWritePos = ").append(this.m_nWritePos).append(" ^= ").append(this.getWritePos()).toString());
            TDebug.out(new StringBuffer().append("availableRead()  = ").append(this.availableRead()).toString());
            TDebug.out(new StringBuffer().append("availableWrite() = ").append(this.availableWrite()).toString());
        }
        if (!this.m_bOpen) {
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("< not open. returning -1.");
            }
            return -1;
        }
        var4_4 = this;
        synchronized (var4_4) {
            if (!this.m_bBlockingRead) {
                if (this.m_trigger != null && this.availableRead() < var3_3) {
                    if (TDebug.TraceCircularBuffer) {
                        TDebug.out("executing trigger.");
                    }
                    this.m_trigger.execute();
                }
                var3_3 = Math.min(this.availableRead(), var3_3);
            }
            var5_5 = var3_3;
            ** GOTO lbl41
            {
                block15: {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var6_7) {
                        if (!TDebug.TraceAllExceptions) break block15;
                        TDebug.out(var6_7);
                    }
                }
                do {
                    if (this.availableRead() == 0) continue block5;
                    var6_8 = Math.min(this.availableRead(), var5_5);
                    while (var6_8 > 0) {
                        var7_9 = Math.min(var6_8, this.m_nSize - this.getReadPos());
                        System.arraycopy(this.m_abData, this.getReadPos(), var1_1, var2_2, var7_9);
                        this.m_nReadPos += var7_9;
                        var2_2 += var7_9;
                        var6_8 -= var7_9;
                        var5_5 -= var7_9;
                    }
                    this.notifyAll();
lbl41:
                    // 2 sources

                } while (var5_5 > 0);
            }
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("After read:");
                TDebug.out(new StringBuffer().append("m_nReadPos  = ").append(this.m_nReadPos).append(" ^= ").append(this.getReadPos()).toString());
                TDebug.out(new StringBuffer().append("m_nWritePos = ").append(this.m_nWritePos).append(" ^= ").append(this.getWritePos()).toString());
                TDebug.out(new StringBuffer().append("availableRead()  = ").append(this.availableRead()).toString());
                TDebug.out(new StringBuffer().append("availableWrite() = ").append(this.availableWrite()).toString());
                TDebug.out(new StringBuffer().append("< completed. Read ").append(var3_3).append(" bytes").toString());
            }
            return var3_3;
        }
    }

    public int write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int write(byte[] var1_1, int var2_2, int var3_3) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out(new StringBuffer().append(">TCircularBuffer.write(): called; nLength: ").append(var3_3).toString());
            TDebug.out(new StringBuffer().append("m_nReadPos  = ").append(this.m_nReadPos).append(" ^= ").append(this.getReadPos()).toString());
            TDebug.out(new StringBuffer().append("m_nWritePos = ").append(this.m_nWritePos).append(" ^= ").append(this.getWritePos()).toString());
            TDebug.out(new StringBuffer().append("availableRead()  = ").append(this.availableRead()).toString());
            TDebug.out(new StringBuffer().append("availableWrite() = ").append(this.availableWrite()).toString());
        }
        var4_4 = this;
        synchronized (var4_4) {
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("entered synchronized block.");
            }
            if (!this.m_bBlockingWrite) {
                var3_3 = Math.min(this.availableWrite(), var3_3);
            }
            var5_5 = var3_3;
            ** GOTO lbl35
            {
                block12: {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var6_7) {
                        if (!TDebug.TraceAllExceptions) break block12;
                        TDebug.out(var6_7);
                    }
                }
                do {
                    if (this.availableWrite() == 0) continue block5;
                    var6_8 = Math.min(this.availableWrite(), var5_5);
                    while (var6_8 > 0) {
                        var7_9 = Math.min(var6_8, this.m_nSize - this.getWritePos());
                        System.arraycopy(var1_1, var2_2, this.m_abData, this.getWritePos(), var7_9);
                        this.m_nWritePos += var7_9;
                        var2_2 += var7_9;
                        var6_8 -= var7_9;
                        var5_5 -= var7_9;
                    }
                    this.notifyAll();
lbl35:
                    // 2 sources

                } while (var5_5 > 0);
            }
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("After write:");
                TDebug.out(new StringBuffer().append("m_nReadPos  = ").append(this.m_nReadPos).append(" ^= ").append(this.getReadPos()).toString());
                TDebug.out(new StringBuffer().append("m_nWritePos = ").append(this.m_nWritePos).append(" ^= ").append(this.getWritePos()).toString());
                TDebug.out(new StringBuffer().append("availableRead()  = ").append(this.availableRead()).toString());
                TDebug.out(new StringBuffer().append("availableWrite() = ").append(this.availableWrite()).toString());
                TDebug.out(new StringBuffer().append("< completed. Wrote ").append(var3_3).append(" bytes").toString());
            }
            return var3_3;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Trigger {
        public void execute();
    }
}

