/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

import java.util.Collection;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.ArraySet;
import org.tritonus.share.sampled.AudioFormats;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioFormatSet
extends ArraySet {
    protected static final AudioFormat[] EMPTY_FORMAT_ARRAY = new AudioFormat[0];

    public AudioFormatSet() {
    }

    public AudioFormatSet(Collection collection) {
        super(collection);
    }

    @Override
    public boolean add(Object object) {
        if (object == null || !(object instanceof AudioFormat)) {
            return false;
        }
        return super.add(object);
    }

    @Override
    public boolean contains(Object object) {
        if (object == null || !(object instanceof AudioFormat)) {
            return false;
        }
        AudioFormat audioFormat = (AudioFormat)object;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!AudioFormats.equals(audioFormat, (AudioFormat)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public Object get(Object object) {
        if (object == null || !(object instanceof AudioFormat)) {
            return null;
        }
        AudioFormat audioFormat = (AudioFormat)object;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            AudioFormat audioFormat2 = (AudioFormat)iterator.next();
            if (!AudioFormats.equals(audioFormat, audioFormat2)) continue;
            return audioFormat2;
        }
        return null;
    }

    public AudioFormat getAudioFormat(AudioFormat audioFormat) {
        return (AudioFormat)this.get(audioFormat);
    }

    public AudioFormat matches(AudioFormat audioFormat) {
        if (audioFormat == null) {
            return null;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            AudioFormat audioFormat2 = (AudioFormat)iterator.next();
            if (!AudioFormats.matches(audioFormat, audioFormat2)) continue;
            return audioFormat2;
        }
        return null;
    }

    public AudioFormat[] toAudioFormatArray() {
        return (AudioFormat[])this.toArray(EMPTY_FORMAT_ARRAY);
    }

    @Override
    public void add(int n, Object object) {
        throw new UnsupportedOperationException("unsupported");
    }

    @Override
    public Object set(int n, Object object) {
        throw new UnsupportedOperationException("unsupported");
    }
}

