/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.sampled.AudioFormats;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioUtils {
    public static long getLengthInBytes(AudioInputStream audioInputStream) {
        return AudioUtils.getLengthInBytes(audioInputStream.getFormat(), audioInputStream.getFrameLength());
    }

    public static long getLengthInBytes(AudioFormat audioFormat, long l) {
        int n = audioFormat.getFrameSize();
        if (l >= 0L && n >= 1) {
            return l * (long)n;
        }
        return -1L;
    }

    public static boolean containsFormat(AudioFormat audioFormat, Iterator iterator) {
        while (iterator.hasNext()) {
            AudioFormat audioFormat2 = (AudioFormat)iterator.next();
            if (!AudioFormats.matches(audioFormat2, audioFormat)) continue;
            return true;
        }
        return false;
    }

    public static long millis2Bytes(long l, AudioFormat audioFormat) {
        return AudioUtils.millis2Bytes(l, audioFormat.getFrameRate(), audioFormat.getFrameSize());
    }

    public static long millis2Bytes(long l, float f, int n) {
        return (long)((float)l * f / 1000.0f * (float)n);
    }

    public static long millis2BytesFrameAligned(long l, AudioFormat audioFormat) {
        return AudioUtils.millis2BytesFrameAligned(l, audioFormat.getFrameRate(), audioFormat.getFrameSize());
    }

    public static long millis2BytesFrameAligned(long l, float f, int n) {
        return (long)((float)l * f / 1000.0f) * (long)n;
    }

    public static long millis2Frames(long l, AudioFormat audioFormat) {
        return AudioUtils.millis2Frames(l, audioFormat.getFrameRate());
    }

    public static long millis2Frames(long l, float f) {
        return (long)((float)l * f / 1000.0f);
    }

    public static long bytes2Millis(long l, AudioFormat audioFormat) {
        return (long)((float)l / audioFormat.getFrameRate() * 1000.0f / (float)audioFormat.getFrameSize());
    }

    public static long frames2Millis(long l, AudioFormat audioFormat) {
        return (long)((float)l / audioFormat.getFrameRate() * 1000.0f);
    }

    public static String NS_or_number(int n) {
        if (n == -1) {
            return "NOT_SPECIFIED";
        }
        return String.valueOf(n);
    }

    public static String NS_or_number(float f) {
        if (f == -1.0f) {
            return "NOT_SPECIFIED";
        }
        return String.valueOf(f);
    }

    public static String format2ShortStr(AudioFormat audioFormat) {
        return new StringBuffer().append(audioFormat.getEncoding()).append("-").append(AudioUtils.NS_or_number(audioFormat.getChannels())).append("ch-").append(AudioUtils.NS_or_number(audioFormat.getSampleSizeInBits())).append("bit-").append(AudioUtils.NS_or_number((int)audioFormat.getSampleRate())).append("Hz-").append(audioFormat.isBigEndian() ? "be" : "le").toString();
    }
}

