/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.TCircularBuffer;
import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TAsynchronousFilteredAudioInputStream
extends AudioInputStream
implements TCircularBuffer.Trigger {
    private static int DEFAULT_BUFFER_SIZE = 327670;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected TCircularBuffer m_circularBuffer;
    private byte[] m_abSingleByte;

    public TAsynchronousFilteredAudioInputStream(AudioFormat audioFormat, long l) {
        this(audioFormat, l, DEFAULT_BUFFER_SIZE);
    }

    public TAsynchronousFilteredAudioInputStream(AudioFormat audioFormat, long l, int n) {
        super(new ByteArrayInputStream(EMPTY_BYTE_ARRAY), audioFormat, l);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.<init>(): begin");
        }
        this.m_circularBuffer = new TCircularBuffer(n, false, true, this);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.<init>(): end");
        }
    }

    @Override
    public int read() throws IOException {
        int n;
        int n2 = -1;
        if (this.m_abSingleByte == null) {
            this.m_abSingleByte = new byte[1];
        }
        n2 = (n = this.read(this.m_abSingleByte)) == -1 ? -1 : this.m_abSingleByte[0] & 0xFF;
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.read(byArray, 0, byArray.length);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.m_circularBuffer.read(byArray, n, n2);
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l2 < l) {
            int n = this.read();
            if (n == -1) {
                return l2;
            }
            ++l2;
        }
        return l;
    }

    @Override
    public int available() throws IOException {
        return this.m_circularBuffer.availableRead();
    }

    @Override
    public void close() throws IOException {
        this.m_circularBuffer.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark not supported");
    }
}

