/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.mixer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;
import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TMixerProvider
extends MixerProvider {
    private static final Mixer.Info[] EMPTY_MIXER_INFO_ARRAY = new Mixer.Info[0];
    private static Map sm_mixerProviderStructs = new HashMap();
    private boolean m_bDisabled;

    public TMixerProvider() {
        this.Block$();
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.<init>(): begin");
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.<init>(): end");
        }
    }

    protected void staticInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MixerProviderStruct getMixerProviderStruct() {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixerProviderStruct(): begin");
        }
        Class clazz = this.getClass();
        if (TDebug.TraceMixerProvider) {
            TDebug.out(new StringBuffer().append("TMixerProvider.getMixerProviderStruct(): called from ").append(clazz).toString());
        }
        Class clazz2 = Class.forName("org.tritonus.share.sampled.mixer.TMixerProvider");
        synchronized (clazz2) {
            MixerProviderStruct mixerProviderStruct = (MixerProviderStruct)sm_mixerProviderStructs.get(clazz);
            if (mixerProviderStruct == null) {
                if (TDebug.TraceMixerProvider) {
                    TDebug.out(new StringBuffer().append("TMixerProvider.getMixerProviderStruct(): creating new MixerProviderStruct for ").append(clazz).toString());
                }
                mixerProviderStruct = new MixerProviderStruct();
                sm_mixerProviderStructs.put(clazz, mixerProviderStruct);
            }
            if (TDebug.TraceMixerProvider) {
                TDebug.out("TMixerProvider.getMixerProviderStruct(): end");
            }
            return mixerProviderStruct;
        }
    }

    protected void disable() {
        if (TDebug.TraceMixerProvider) {
            TDebug.out(new StringBuffer().append("disabling ").append(this.getClass().getName()).toString());
        }
        this.m_bDisabled = true;
    }

    protected boolean isDisabled() {
        return this.m_bDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMixer(Mixer mixer) {
        MixerProviderStruct mixerProviderStruct;
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.addMixer(): begin");
        }
        MixerProviderStruct mixerProviderStruct2 = mixerProviderStruct = this.getMixerProviderStruct();
        synchronized (mixerProviderStruct2) {
            mixerProviderStruct.m_mixers.add(mixer);
            if (mixerProviderStruct.m_defaultMixer == null) {
                mixerProviderStruct.m_defaultMixer = mixer;
            }
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.addMixer(): end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMixer(Mixer mixer) {
        MixerProviderStruct mixerProviderStruct;
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.removeMixer(): begin");
        }
        MixerProviderStruct mixerProviderStruct2 = mixerProviderStruct = this.getMixerProviderStruct();
        synchronized (mixerProviderStruct2) {
            mixerProviderStruct.m_mixers.remove(mixer);
            if (mixerProviderStruct.m_defaultMixer == mixer) {
                mixerProviderStruct.m_defaultMixer = null;
            }
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.removeMixer(): end");
        }
    }

    @Override
    public boolean isMixerSupported(Mixer.Info info) {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.isMixerSupported(): begin");
        }
        boolean bl = false;
        Mixer.Info[] infoArray = this.getMixerInfo();
        int n = 0;
        while (n < infoArray.length) {
            if (infoArray[n].equals(info)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.isMixerSupported(): end");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer getMixer(Mixer.Info info) {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixer(): begin");
        }
        MixerProviderStruct mixerProviderStruct = this.getMixerProviderStruct();
        Mixer mixer = null;
        MixerProviderStruct mixerProviderStruct2 = mixerProviderStruct;
        synchronized (mixerProviderStruct2) {
            if (info == null) {
                mixer = mixerProviderStruct.m_defaultMixer;
            } else {
                Iterator iterator = mixerProviderStruct.m_mixers.iterator();
                while (iterator.hasNext()) {
                    Mixer mixer2 = (Mixer)iterator.next();
                    if (!mixer2.getMixerInfo().equals(info)) continue;
                    mixer = mixer2;
                    break;
                }
            }
        }
        if (mixer == null) {
            throw new IllegalArgumentException(new StringBuffer().append("no mixer available for ").append(info).toString());
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixer(): end");
        }
        return mixer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer.Info[] getMixerInfo() {
        MixerProviderStruct mixerProviderStruct;
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixerInfo(): begin");
        }
        HashSet hashSet = new HashSet();
        MixerProviderStruct mixerProviderStruct2 = mixerProviderStruct = this.getMixerProviderStruct();
        synchronized (mixerProviderStruct2) {
            Iterator iterator = mixerProviderStruct.m_mixers.iterator();
            while (iterator.hasNext()) {
                Mixer mixer = (Mixer)iterator.next();
                hashSet.add(mixer.getMixerInfo());
            }
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixerInfo(): end");
        }
        return (Mixer.Info[])hashSet.toArray(EMPTY_MIXER_INFO_ARRAY);
    }

    private /* synthetic */ void Block$() {
        this.m_bDisabled = false;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MixerProviderStruct {
        public List m_mixers = new ArrayList();
        public Mixer m_defaultMixer = null;
    }
}

