/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.ext;

import org.xml.sax.Attributes;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attributes2Impl
extends AttributesImpl
implements Attributes2 {
    private boolean[] flags;

    public Attributes2Impl() {
    }

    public Attributes2Impl(Attributes attributes) {
        super(attributes);
    }

    @Override
    public boolean isSpecified(int n) {
        if (n < 0 || n >= this.getLength()) {
            throw new ArrayIndexOutOfBoundsException(new StringBuffer().append("No attribute at index: ").append(n).toString());
        }
        return this.flags[n];
    }

    @Override
    public boolean isSpecified(String string, String string2) {
        int n = this.getIndex(string, string2);
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuffer().append("No such attribute: local=").append(string2).append(", namespace=").append(string).toString());
        }
        return this.flags[n];
    }

    @Override
    public boolean isSpecified(String string) {
        int n = this.getIndex(string);
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuffer().append("No such attribute: ").append(string).toString());
        }
        return this.flags[n];
    }

    @Override
    public void setAttributes(Attributes attributes) {
        int n = attributes.getLength();
        super.setAttributes(attributes);
        this.flags = new boolean[n];
        if (attributes instanceof Attributes2) {
            Attributes2 attributes2 = (Attributes2)attributes;
            int n2 = 0;
            while (n2 < n) {
                this.flags[n2] = attributes2.isSpecified(n2);
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            this.flags[n3] = true;
            ++n3;
        }
    }

    @Override
    public void addAttribute(String string, String string2, String string3, String string4, String string5) {
        super.addAttribute(string, string2, string3, string4, string5);
        int n = this.getLength();
        if (n < this.flags.length) {
            boolean[] blArray = new boolean[n];
            System.arraycopy(this.flags, 0, blArray, 0, this.flags.length);
            this.flags = blArray;
        }
        this.flags[n - 1] = true;
    }

    @Override
    public void removeAttribute(int n) {
        int n2 = this.getLength() - 1;
        super.removeAttribute(n);
        if (n != n2) {
            System.arraycopy(this.flags, n + 1, this.flags, n, n2 - n);
        }
    }

    public void setSpecified(int n, boolean bl) {
        if (n < 0 || n >= this.getLength()) {
            throw new ArrayIndexOutOfBoundsException(new StringBuffer().append("No attribute at index: ").append(n).toString());
        }
        this.flags[n] = bl;
    }
}

